#version 330
#extension GL_EXT_gpu_shader4 : enable
//fintyMod01.fsh by  foran
//https://www.shadertoy.com/view/tdcGRn
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


float o(vec3 p)
{
  return cos(p.x) + cos(p.y*.5) + cos(p.z) + cos(p.y*20. + iTime)*.1 + texture(iChannel0, p.xy*.91).r*2.5 ;//  бочки в небе
}

float water( vec3 p)
{
  float d = p.y + texture(iChannel1, p.xz*.1+vec2(iTime*.01)).r*.1;//+ texture(iChannel1, p.xz*.1-vec2(iTime*.05)).r*.1;//вода
  d = min(d, mix(length(p-vec3(0.,1.,iTime+2.5)) - 1., length(p.xy-vec2(sin(p.z),1.+cos(p.z))) - .5, cos(iTime)*.45+.5));//финтифлюшка
  return d;
}

float map( vec3 p)
{
  float d = min(o(p), water(p));
  return d;
}

vec3 rm( vec3 ro ,vec3 rd)
{
  vec3 p = ro;
  for(int i=0; i<64; i++)
  {
    float d = map(p);
  p += rd *d;
  }
return p;
}

vec3 normal( vec3 p)
{
  vec2 eps = vec2(0.01, 0.);
  vec3 n;
  n.x = map(p) - map(p+eps.xyy);
  n.y = map(p) - map(p+eps.yxy);
  n.z = map(p) - map(p+eps.yyx);
  return normalize(n);
}

vec3 shade( vec3 ro, vec3 rd, vec3 n, vec3 p)
{
  vec3 col = vec3(0.);
  col += vec3(1.) * max(0., dot(n, normalize(vec3(1.,1.,1.))))*.5;
  vec3 fog = mix(vec3(cos(iTime)*.5+.5, .7, .5), vec3(0.,.7,1.5), rd.x) * (length(p-ro)*.05 );;

  col += fog;
  return col;
}

mat2 rot( float v)
{
  float a = 1.;
  float b = sin(v)*0.1;
  return mat2( a,-b,b,a);
}
void main (void)
//void mainImage(out vec4 fragColor,in vec2 fragCoord)
{
  vec2 uv=vec2(gl_FragCoord.x/iResolution.x,gl_FragCoord.y/iResolution.y);
uv-=.5;
uv/=vec2(iResolution.y/iResolution.x,1);

  vec3 ro = vec3( 0., 1., iTime);
  vec3 rd = normalize( vec3(uv, 1.) );
  rd.xy = rot(iTime*.91) * rd.xy;
  vec3 p = rm(ro ,rd);
vec3 n = normal(p);

  vec3 col = shade(ro,rd,n,p);
  for(int i=0; i<3; i++)
  if(water(p)<.1)
  {
    rd = reflect(  rd, n);
    p += rd*.1;
  ro = p;
    p = rm(ro,rd);
    n = normal(p);
    col = vec3(0.5,.47,1.) * shade(ro,rd,n,p);
  }
  vec4 out_color=vec4(1.);
  out_color=vec4(col,1.);
  gl_FragColor=vec4(out_color);
}
